/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinStatic;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.IMListener;
import cds.aladin.MyInputStream;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGStatic;
import cds.aladin.PlanImage;
import cds.aladin.Repere;
import cds.aladin.SaveStatic;
import cds.aladin.Tok;
import cds.aladin.ViewSimpleStatic;
import cds.aladin.ViewStatic;
import cds.aladin.stc.STCCircle;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCPolygon;
import cds.aladin.stc.STCStringParser;
import cds.fits.HeaderFits;
import cds.tools.pixtools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageMaker {
    private Aladin aladin = null;
    public int pixel_max = -1;
    public int res_max = -1;

    public ImageMaker() throws Exception {
        this(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageMaker(int trace) throws Exception {
        if (this.aladin == null) {
            ImageMaker imageMaker = this;
            synchronized (imageMaker) {
                if (this.aladin == null) {
                    this.aladin = new AladinStatic(trace);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preview(String hipsUrlOrPath, double raICRS, double deICRS, double radDeg, String filename, int width, int height, String fmt, String overlays) throws Exception {
        try (FileOutputStream output = null;){
            output = new FileOutputStream(new File(filename));
            this.preview(hipsUrlOrPath, raICRS, deICRS, radDeg, output, width, height, fmt, overlays);
        }
    }

    public void preview(String hipsUrlOrPath, double raICRS, double deICRS, double radDeg, OutputStream output, int width, int height, String fmt, String overlays) throws Exception {
        PlanBGStatic p = new PlanBGStatic(this.aladin, hipsUrlOrPath, false);
        ViewSimpleStatic vs = new ViewSimpleStatic(this.aladin);
        ((ViewStatic)this.aladin.view).setViewSimple(vs);
        vs.setViewParam(p, width, height, new Coord(raICRS, deICRS), radDeg);
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g = (Graphics2D)img.getGraphics();
        p.drawBackground(g, vs);
        p.drawLosangesNow(g, vs, img);
        if (overlays != null) {
            g.setColor(Color.yellow);
            g.setFont(Aladin.BOLD);
            Tok tok = new Tok(overlays, " ,;");
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken();
                if (s.equals("grid")) {
                    vs.drawGrid(g, null, 0, 0);
                    continue;
                }
                if (s.equals("scale")) {
                    vs.drawScale(g, vs, 0, 0);
                    continue;
                }
                if (s.equals("size")) {
                    vs.drawSize(g, 0, 0);
                    continue;
                }
                if (s.equals("NE")) {
                    vs.drawNE(g, p.projd, 0, 0);
                    continue;
                }
                if (s.equals("reticle")) {
                    this.aladin.view.repere = new Repere((Plan)p, new Coord(raICRS, deICRS));
                    this.aladin.view.repere.setType(1);
                    vs.drawRepere(g, 0, 0);
                    continue;
                }
                if (!s.startsWith("label")) continue;
                int i = s.indexOf(61);
                String label = i > 0 ? s.substring(i + 1) : new Coord(raICRS, deICRS).getSexa();
                p.label = label;
                vs.drawLabel(g, 0, 0);
            }
        }
        vs.drawCredit(g, 0, 0);
        p.drawForeground(g, vs);
        ImageIO.write((RenderedImage)img, fmt, output);
        p.Free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fits(String hipsUrlOrPath, double raICRS, double deICRS, double radDeg, String filename, int width, int height, Object ... optionalParams) throws Exception {
        try (FileOutputStream output = null;){
            output = new FileOutputStream(new File(filename));
            this.fits(hipsUrlOrPath, raICRS, deICRS, radDeg, (OutputStream)output, width, height, optionalParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fits(String hipsUrlOrPath, String pos, double res, boolean takeBoundingBox, String filename, Object ... optionalParams) throws Exception {
        try (FileOutputStream output = null;){
            output = new FileOutputStream(new File(filename));
            this.fits(hipsUrlOrPath, pos, res, takeBoundingBox, (OutputStream)output, optionalParams);
        }
    }

    public void fits(String hipsUrlOrPath, String pos, int order, boolean takeBoundingBox, String filename, Object ... optionalParams) throws Exception {
        double res = Util.pixRes(1 << order + 9);
        this.fits(hipsUrlOrPath, pos, res, takeBoundingBox, filename, optionalParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fits(String hipsUrlOrPath, InputStream wcsFileStream, String filename) {
        MyInputStream myStream = null;
        try {
            myStream = new MyInputStream(wcsFileStream);
            myStream = myStream.startRead();
            HeaderFits hf = new HeaderFits(myStream);
            myStream.close();
            this.fits(hipsUrlOrPath, hf, filename);
        }
        catch (Exception e) {
            Aladin.trace(3, "Error : could not create HeaderFits object");
            return;
        }
        finally {
            if (myStream != null) {
                try {
                    myStream.close();
                }
                catch (Exception e1) {
                    Aladin.trace(3, "Error : could not create HeaderFits object");
                }
            }
        }
    }

    public void fits(String hipsUrlOrPath, String wcsParams, String filename) throws Exception {
        HeaderFits hf = new HeaderFits(wcsParams);
        this.fits(hipsUrlOrPath, hf, filename);
    }

    public void fits(String hipsUrlOrPath, HeaderFits fitsHeader, String filename) throws Exception {
        int width = 0;
        int height = 0;
        double rotation = 0.0;
        String projection = null;
        try (FileOutputStream output = null;){
            Calib calib = new Calib(fitsHeader);
            Coord center = calib.getImgCenter();
            if (center == null) {
                throw new IllegalArgumentException("Unable to parse for target coordinates");
            }
            width = Long.valueOf(Math.round(calib.getImgSize().getWidth())).intValue();
            height = Long.valueOf(Math.round(calib.getImgSize().getHeight())).intValue();
            projection = Calib.getProjName(calib.getProj());
            rotation = calib.getProjRot();
            PlanBGStatic p = new PlanBGStatic(this.aladin, hipsUrlOrPath, true);
            double calcRes = 0.0;
            int calc_nbpoints = 0;
            if (this.pixel_max > 0 && (calc_nbpoints = (int)(calib.widtha * 60.0 * 60.0 / (calcRes = Util.pixRes(1 << p.minOrder + 9)))) > this.pixel_max) {
                throw new IllegalArgumentException("Generated FITS cannot exceed " + this.pixel_max + "\u00c2\u00b2 (" + calc_nbpoints + "^2 requested)");
            }
            output = new FileOutputStream(new File(filename));
            if (!projection.trim().isEmpty()) {
                ((Plan)p).modifyProj(projection);
            }
            ViewSimpleStatic vs = new ViewSimpleStatic(this.aladin);
            ((ViewStatic)this.aladin.view).setViewSimple(vs);
            vs.setViewParam(p, width, height, center, calib.widtha);
            boolean fullRes = false;
            if (this.res_max < 0) {
                fullRes = false;
            } else if (this.res_max == 0) {
                fullRes = true;
            } else if (this.res_max > 0 && (calc_nbpoints = (int)(calib.widtha * 60.0 * 60.0 / (calcRes = Util.pixRes(1 << p.maxOrder - 1 + 9)))) <= this.res_max) {
                fullRes = true;
            }
            PlanImage pi = this.aladin.calque.createCropImage(vs, null, fullRes);
            if (rotation != 0.0) {
                pi.projd.setProjRot(rotation);
            }
            SaveStatic save = new SaveStatic(this.aladin);
            save.saveImageFITS(output, pi);
            if (output != null) {
                output.close();
            }
            pi.Free();
        }
    }

    public void fits(String hipsUrlOrPath, double raICRS, double deICRS, double radDeg, OutputStream output, int width, int height, Object ... optionalParams) throws Exception {
        PlanBGStatic p = new PlanBGStatic(this.aladin, hipsUrlOrPath, true);
        double rotationAngle = 0.0;
        if (optionalParams.length > 0) {
            String projection;
            if (optionalParams[0] instanceof String && !(projection = (String)optionalParams[0]).trim().isEmpty()) {
                ((Plan)p).modifyProj(projection);
            }
            if (optionalParams.length > 1 && Double.class.isInstance(optionalParams[1])) {
                rotationAngle = (Double)optionalParams[1];
            }
        }
        ViewSimpleStatic vs = new ViewSimpleStatic(this.aladin);
        ((ViewStatic)this.aladin.view).setViewSimple(vs);
        vs.setViewParam(p, width, height, new Coord(raICRS, deICRS), radDeg);
        PlanImage pi = this.aladin.calque.createCropImage(vs, true);
        if (rotationAngle != 0.0) {
            pi.projd.setProjRot(rotationAngle);
        }
        SaveStatic save = new SaveStatic(this.aladin);
        save.saveImageFITS(output, pi);
        pi.Free();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fits(String hipsUrlOrPath, String pos, double res, boolean takeBoundingBox, OutputStream output, Object ... optionalParams) throws Exception {
        void var22_21;
        int orderMaxCheck;
        double full_res;
        int calc_nbpoints;
        PlanBGStatic p = new PlanBGStatic(this.aladin, hipsUrlOrPath, true);
        boolean fullRes = false;
        double rotationAngle = 0.0;
        double raICRS = 0.0;
        double deICRS = 0.0;
        int width = 0;
        int height = 0;
        double size = 0.0;
        double calc = 0.0;
        Object var22_16 = null;
        if (pos == null) throw new Exception("Target is mandatory!");
        STCStringParser parser = new STCStringParser();
        List<STCObj> stcObjs = parser.parse(pos, true);
        if (stcObjs == null || stcObjs.isEmpty()) throw new Exception("Unable to parse the position input!");
        if (stcObjs.get(0) instanceof STCCircle) {
            STCCircle circle = (STCCircle)stcObjs.get(0);
            raICRS = circle.getCenter().al;
            deICRS = circle.getCenter().del;
            size = 2.0 * circle.getRadius();
            width = height = (int)(size * 60.0 * 60.0 / res);
            STCCircle sTCCircle = circle;
        } else if (stcObjs.get(0) instanceof STCPolygon) {
            STCPolygon polygon = (STCPolygon)stcObjs.get(0);
            double[] xminMax = cds.tools.Util.getMinMax(polygon.getxCorners());
            double[] yminMax = cds.tools.Util.getMinMax(polygon.getyCorners());
            raICRS = (xminMax[0] + xminMax[1]) / 2.0;
            Coord c1 = new Coord(xminMax[1], yminMax[0]);
            Coord c2 = new Coord(xminMax[0], yminMax[0]);
            size = Coord.getDist(c1, c2);
            width = (int)(size * 60.0 * 60.0 / res);
            deICRS = (yminMax[0] + yminMax[1]) / 2.0;
            c1 = new Coord(xminMax[0], yminMax[1]);
            c2 = new Coord(xminMax[0], yminMax[0]);
            calc = Coord.getDist(c1, c2);
            height = (int)(calc * 60.0 * 60.0 / res);
            size = size > calc ? size : calc;
            STCPolygon sTCPolygon = polygon;
        }
        if (takeBoundingBox) {
            Object var22_20 = null;
        }
        int nbpoints = (int)(size * 60.0 * 60.0 / res);
        ImageMaker.checkPixelLimit(width, height, p);
        if (this.pixel_max > 0 && nbpoints > this.pixel_max) {
            Aladin.trace(3, "Generated FITS exceeds " + this.pixel_max + "\u00c2\u00b2 (" + nbpoints + "^2 requested).. ");
            throw new Exception("Generated FITS cannot exceed " + this.pixel_max + "\u00c2\u00b2 (" + nbpoints + "^2 requested)");
        }
        if (this.res_max < 0) {
            fullRes = false;
        } else if (this.res_max == 0) {
            fullRes = true;
        } else if (this.res_max > 0 && (calc_nbpoints = (int)(size * 60.0 * 60.0 / (full_res = Util.pixRes(1 << (orderMaxCheck = p.maxOrder - 1) + 9)))) <= this.res_max) {
            fullRes = true;
        }
        String projection = null;
        if (optionalParams.length > 0) {
            if (optionalParams[0] != null && optionalParams[0] instanceof String && !(projection = (String)optionalParams[0]).trim().isEmpty()) {
                ((Plan)p).modifyProj(projection);
            }
            if (optionalParams.length > 1 && optionalParams[1] != null && Double.class.isInstance(optionalParams[1])) {
                rotationAngle = (Double)optionalParams[1];
            }
        }
        if (projection == null && size < 30.0) {
            ((Plan)p).modifyProj("Tangential");
        }
        ViewSimpleStatic vs = new ViewSimpleStatic(this.aladin);
        ((ViewStatic)this.aladin.view).setViewSimple(vs);
        vs.setViewParam(p, width, height, new Coord(raICRS, deICRS), size);
        PlanImage pi = this.aladin.calque.createCropImage(vs, (STCObj)var22_21, fullRes);
        if (pi.pixels == null) {
            throw new Exception("Unable to generate request. Please consider retrying later and/or with smaller field of view or lower order/resolution");
        }
        if (rotationAngle != 0.0) {
            pi.projd.setProjRot(rotationAngle);
        }
        SaveStatic save = new SaveStatic(this.aladin);
        save.saveImageFITS(output, pi);
        pi.Free();
    }

    public synchronized void makeIMSettings(int pixel_max, int res_max, IMListener imListener, boolean bubbleWrap) {
        this.pixel_max = pixel_max;
        this.res_max = res_max;
        this.aladin.makeIMSettings(imListener, bubbleWrap);
    }

    public static void checkPixelLimit(int width, int height, PlanBG planBG) throws Exception {
        int bitpix = planBG.getBitpix() == -64 ? -64 : -32;
        long limit = (long)width * (long)height * (long)(Math.abs(bitpix) / 8);
        if (limit < Integer.MIN_VALUE || limit > Integer.MAX_VALUE) {
            throw new Exception("Unable to process large request. Please consider retrying with smaller field of view or lower order/resolution");
        }
    }

    public static void main(String[] argv) {
        try {
            ImageMaker im = new ImageMaker(3);
            long t = System.currentTimeMillis();
            im.fits("http://alasky.u-strasbg.fr/MAMA/CDS_P_MAMA_srcj", 247.55114, -25.12124, 0.2, "D:/Test.fits", 900, 900, new Object[0]);
            long t1 = System.currentTimeMillis();
            System.out.println("C'est termin\u00e9 en " + (double)(t1 - t) / 1000.0 + "s");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

